<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Tarea extends Model
{
    use HasFactory;

    protected $fillable = [
        'titulo',
        'descripcion',
        'tarea_estado_id',
        'fecha_entrega',
    ];

    public function estado()
    {
        return $this->belongsTo(TareaEstado::class, 'tarea_estado_id');
    }
}
